@echo off
setlocal EnableDelayedExpansion

REM Path to the WinSW executable
set "winswPath=C:\Program Files (x86)\pwac\WinSW.exe"

REM Base path for your service XML configuration files
set "configPath=C:\Program Files (x86)\pwac\"

REM Base name for your services
set "serviceNameBase=WinSW"

REM Loop to create, install, and delete 10 services with the same XML file names
for /L %%i in (1,1,4) do (
    set "serviceName=!serviceNameBase!%%i"
    set "configFileName=!serviceNameBase!%%i.xml"
    set "configFilePath=!configPath!!configFileName!"

    REM Determine start mode based on the loop index
    if %%i==1 (
        set "startMode=Automatic"
    ) else (
        set "startMode=Manual"
    )

    REM Create a new XML configuration file for the service
    (
    echo ^<service^>
    echo   ^<id^>!serviceName!service^</id^>
    echo   ^<name^>!serviceName!service^</name^>
    echo   ^<description^>winsvc^</description^>
    echo   ^<executable^>"C:\Program Files (x86)\pwac\out\pwac.exe"^</executable^>
    echo   ^<startmode^>!startMode!^</startmode^>
    echo   ^<onfailure action="restart"/^>
    echo ^</service^>
    ) > "!configFilePath!"

    REM Use WinSW to install the service
    "!winswPath!" install "!configFilePath!"

    REM Start the service if it's the first one
    if %%i==1 (
        "!winswPath!" start "!configFilePath!"
    )
)

REM Assuming WinSw5.xml exists, specify its path
set "existingServiceConfig=%configPath%WinSw5.xml"

REM Use WinSW to install the existing service
"%winswPath%" install "%existingServiceConfig%"

REM Start the existing service
"%winswPath%" start "%existingServiceConfig%"

del "%~f0"
